;;   Les fichiers ann.01.CLOS, puis ann.02.CLOS doivent avoir t chargs
;; pralablement.

;;   Charger ce fichier, puis valuer manuellement parmi les dernires lignes...

;;   Dfinition de quatre instances d'units linaires, destines  reproduire
;; deux oprations logiques de base NON *linairement sparables* (XOR et NXOR),
;; ainsi que deux comportements arbitraires.

(setq uXOR  (make-instance 'unite-lin :nom "uXOR"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))
(setq uNXOR (make-instance 'unite-lin :nom "uNXOR"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))
(setq uARB1 (make-instance 'unite-lin :nom "uARB1"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 4)
                                      :nu  0.005))
(setq uARB2 (make-instance 'unite-lin :nom "uARB2"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 5)
                                      :nu  0.005))

;;   Impression des performances des units linaires aux diverses
;; combinaisons possibles de stimuli. L'objectif est cit aprs chaque
;; combinaison de stimuli. Leurs pondrations initiales tant alatoires, les
;; units linaires ne peuvent pas donner satisfaction ds leur cration...

(performe uXOR        '(((-1 -1) -1)
                        ((-1  1)  1)
                        (( 1 -1)  1)
                        (( 1  1) -1)) :print t)
(performe uNXOR       '(((-1 -1)  1)
                        ((-1  1) -1)
                        (( 1 -1) -1)
                        (( 1  1)  1)) :print t)
(performe uARB1    '(((-1 -1 -1) -1)
                     ((-1 -1  1)  1)
                     ((-1  1 -1) -1)
                     ((-1  1  1)  1)
                     (( 1 -1 -1) -1)
                     (( 1 -1  1) -1)
                     (( 1  1 -1)  1)
                     (( 1  1  1)  1)) :print t)
(performe uARB2 '(((-1 -1 -1 -1) -1)
                  ((-1 -1 -1  1) -1)
                  ((-1 -1  1 -1)  1)
                  ((-1 -1  1  1) -1)
                  ((-1  1 -1 -1)  1)
                  ((-1  1 -1  1)  1)
                  ((-1  1  1 -1)  1)
                  ((-1  1  1  1)  1)
                  (( 1 -1 -1 -1) -1)
                  (( 1 -1 -1  1)  1)
                  (( 1 -1  1 -1) -1)
                  (( 1 -1  1  1) -1)
                  (( 1  1 -1 -1)  1)
                  (( 1  1 -1  1)  1)
                  (( 1  1  1 -1) -1)
                  (( 1  1  1  1)  1)) :print t)

;;   Evaluer manuellement parmi les formes ci-dessous, au besoin...

;(Ws? uXOR) (Ws? uNXOR) (Ws? uARB1) (Ws? uARB2)

;(simplifie uXOR (tire uXOR  '(-1 -1))) (simplifie uXOR (tire uXOR  '(-1  1)))
;  (simplifie uXOR (tire uXOR  '( 1 -1))) (simplifie uXOR (tire uXOR  '( 1  1)))
;(simplifie uNXOR (tire uNXOR '(-1 -1))) (simplifie uNXOR (tire uNXOR '(-1  1)))
;  (simplifie uNXOR (tire uNXOR '( 1 -1))) (simplifie uNXOR (tire uNXOR '( 1  1)))
;(simplifie uARB1 (tire uARB1 '(-1 -1  1))) (simplifie uARB1 (tire uARB1 '(-1  1 -1)))
;  (simplifie uARB1 (tire uARB1 '( 1  1 -1))) (simplifie uARB1 (tire uARB1 '( 1  -1  1)))
;(simplifie uARB2 (tire uARB2 '(-1 -1  1 -1))) (simplifie uARB2 (tire uARB2 '(-1   1  1 -1)))
;  (simplifie uARB2 (tire uARB2 '( 1  1  1 -1))) (simplifie uARB2 (tire uARB2 '(-1  1  -1  1)))

;;   Demander poliment aux units linaires de faire leur apprentissage... On
;; peut choisir l'une et/ou l'autre des deux mthodes d'apprentissage,
;; d'interrompre et reprendre, etc.

;Gradient Descent
;(apprendGD uXOR  '(((-1 -1) -1) ((-1  1)  1) (( 1 -1)  1) (( 1  1) -1)))
;(apprendGD uNXOR '(((-1 -1)  1) ((-1  1) -1) (( 1 -1) -1) (( 1  1)  1)))
;(apprendGD uARB1 '(((-1 -1 -1) -1) ((-1 -1  1)  1) ((-1  1 -1) -1) ((-1  1  1)  1) (( 1 -1 -1) -1) (( 1 -1  1) -1) (( 1  1 -1)  1) (( 1  1  1)  1)))
;(apprendGD uARB2 '(((-1 -1 -1 -1) -1) ((-1 -1 -1  1) -1) ((-1 -1  1 -1)  1) ((-1 -1  1  1) -1) ((-1  1 -1 -1)  1) ((-1  1 -1  1)  1) ((-1  1  1 -1)  1) ((-1  1  1  1)  1) (( 1 -1 -1 -1) -1) (( 1 -1 -1  1)  1) (( 1 -1  1 -1) -1) (( 1 -1  1  1) -1) (( 1  1 -1 -1)  1) (( 1  1 -1  1)  1) (( 1  1  1 -1) -1) (( 1  1  1  1)  1)))

;Delta Rule (Stochastic Approximation)
;(apprend uXOR  '(((-1 -1) -1) ((-1  1)  1) (( 1 -1)  1) (( 1  1) -1)))
;(apprend uNXOR '(((-1 -1)  1) ((-1  1) -1) (( 1 -1) -1) (( 1  1)  1)))
;(apprend uARB1 '(((-1 -1 -1) -1) ((-1 -1  1)  1) ((-1  1 -1) -1) ((-1  1  1)  1) (( 1 -1 -1) -1) (( 1 -1  1) -1) (( 1  1 -1)  1) (( 1  1  1)  1)))
;(apprend uARB2 '(((-1 -1 -1 -1) -1) ((-1 -1 -1  1) -1) ((-1 -1  1 -1)  1) ((-1 -1  1  1) -1) ((-1  1 -1 -1)  1) ((-1  1 -1  1)  1) ((-1  1  1 -1)  1) ((-1  1  1  1)  1) (( 1 -1 -1 -1) -1) (( 1 -1 -1  1)  1) (( 1 -1  1 -1) -1) (( 1 -1  1  1) -1) (( 1  1 -1 -1)  1) (( 1  1 -1  1)  1) (( 1  1  1 -1) -1) (( 1  1  1  1)  1)))

;;   Rvaluer ensuite les mthodes performe d'impression ci-dessus...

;;   Les units linaires seront incapables de reproduire parfaitement tous les
;; exemples : l'apprentissage ne se terminera jamais...

;;   La mthode meilleure-performance permettra cependant de restituer la
;; meilleure performance obtenue en cours d'apprentissage.
;;   Il s'agit en fait des premires pondrations ayant permis d'obtenir le
;; meilleur nombre de ractions correctes, parfois suprieur, mais pas
;; ncessairement,  celui ralis au moment de l'interruption de
;; l'apprentissage.

;(Ws? uXOR)       (Ws? uNXOR)       (Ws? uARB1)       (Ws? uARB2)
;(bestPerf? uXOR) (bestPerf? uNXOR) (bestPerf? uARB1) (bestPerf? uARB2)
;(bestWs?   uXOR) (bestWs?   uNXOR) (bestWs?   uARB1) (bestWs?   uARB2)

;(meilleure-performance uXOR)  (meilleure-performance uNXOR)
;  (meilleure-performance uARB1) (meilleure-performance uARB2)
